<?php
// no direct access
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Session\Session;
class plgButtonEdocmanCategoryShortcode extends CMSPlugin
{
	protected $app;

	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 */
	protected $autoloadLanguage = true;
	/**
	 * Display the button
	 *
	 * @return array A four element array of (article_id, article_title, category_id, object)
	 */
	public function onDisplay($name)
	{	
		if ($this->app->isClient('site'))
		{
			return;
		}
		
		$function = "jSelectEdocmanCategoryShortcode";
		$js = "
		function jSelectEdocman(id, title, object) 
		{
			var tag = '{edocmancategory ' + id + '}';
			jInsertEditorText(tag, '".$name."');
			SqueezeBox.close();
		}";
		
		$doc = Factory::getDocument();
		$doc->addScriptDeclaration($js);
		$link = 'index.php?option=com_edocman&amp;view=categories&amp;layout=modal&amp;function='.$function.'&amp;tmpl=component&amp;'.Session::getFormToken().'=1&amp;editor=' . $name;


		$button1 = new CMSObject;

		$button1->modal = true;
		$button1->link  = $link;
		$button1->text  = Text::_('Category-Shortcode');

		if (version_compare(JVERSION, '4.0.0-dev', 'ge'))
		{
			$button1->name    = $this->_type . '_' . $this->_name;
			$button1->icon    = 'file';
			$button1->iconSVG = '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-code" viewBox="0 0 16 16">
								  <path d="M6.646 5.646a.5.5 0 1 1 .708.708L5.707 8l1.647 1.646a.5.5 0 0 1-.708.708l-2-2a.5.5 0 0 1 0-.708l2-2zm2.708 0a.5.5 0 1 0-.708.708L10.293 8 8.646 9.646a.5.5 0 0 0 .708.708l2-2a.5.5 0 0 0 0-.708l-2-2z"/>
								  <path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2zm10-1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1z"/>
								</svg>';

			$button1->options = [
				'height'     => '300px',
				'width'      => '800px',
				'bodyHeight' => '70',
				'modalWidth' => '80',
			];
		}
		else
		{
			$button1->class   = 'btn';
			$button1->name    = 'file';
			$button1->options = "{handler: 'iframe', size: {x: 800, y: 500}}";
		}

		return $button1;
	}
}
